/*
 * Decompiled with CFR 0.152.
 */
package com.sun.lwuit.html;

import com.sun.lwuit.html.HTMLListItem;

class HTMLListIndex
extends HTMLListItem {
    int index;
    int listType;
    static final String[] CSS_OL_TYPES = new String[]{"decimal", "upper-alpha", "lower-alpha", "upper-roman", "lower-roman", "none"};
    static final int LIST_NUMERIC = 0;
    private static final int LIST_UPPERCASE = 1;
    private static final int LIST_LOWERCASE = 2;
    private static final int LIST_ROMAN_UPPER = 3;
    private static final int LIST_ROMAN_LOWER = 4;
    private static final int LIST_NONE = 5;
    private static final String[] ROMAN_NUMERALS_ONES = new String[]{"", "I", "II", "III", "IV", "V", "VI", "VII", "VIII", "IX"};
    private static final String[] ROMAN_NUMERALS_TENS = new String[]{"", "X", "XX", "XXX", "XL", "L", "LX", "LXX", "LXXX", "XC"};

    private String getListIndexString(int index, int type) {
        if (index <= 0) {
            return index + ". ";
        }
        switch (type) {
            case 0: {
                return index + ". ";
            }
            case 1: {
                return HTMLListIndex.getLiteral(index, 'A');
            }
            case 2: {
                return HTMLListIndex.getLiteral(index, 'a');
            }
            case 3: {
                return this.getRomanIndexString(index);
            }
            case 4: {
                return this.getRomanIndexString(index).toLowerCase();
            }
        }
        return "    ";
    }

    static String getLiteral(int index, char baseChar) {
        String literal = "";
        while (index > 0) {
            literal = (char)(index % 26 + baseChar - 1) + literal;
            index /= 26;
        }
        return literal + ". ";
    }

    private String getRomanIndexString(int index) {
        return ROMAN_NUMERALS_TENS[(index %= 100) / 10] + ROMAN_NUMERALS_ONES[index % 10] + ". ";
    }

    public HTMLListIndex(int index, int listType) {
        this.index = index;
        this.listType = listType;
        this.setText(this.getListIndexString(index, listType));
        this.getStyle().setMargin(0, 0, 0, 0);
        this.getStyle().setPadding(0, 0, 0, 0);
        this.getUnselectedStyle().setBgTransparency(0);
    }

    public void setStyleType(int type) {
        if (type != -1) {
            this.listType = type - 4;
            if (this.listType < 0) {
                this.listType = 5;
            }
            this.setText(this.getListIndexString(this.index, this.listType));
            this.repaint();
        }
    }

    public void setImage(String imageUrl) {
    }
}

