/*
 * Decompiled with CFR 0.152.
 */
package com.sun.lwuit.spinner;

import com.sun.lwuit.Component;
import com.sun.lwuit.Display;
import com.sun.lwuit.Graphics;
import com.sun.lwuit.Image;
import com.sun.lwuit.List;
import com.sun.lwuit.TextArea;
import com.sun.lwuit.TextField;
import com.sun.lwuit.geom.Dimension;
import com.sun.lwuit.list.DefaultListCellRenderer;
import com.sun.lwuit.list.ListCellRenderer;
import com.sun.lwuit.list.ListModel;
import com.sun.lwuit.plaf.Style;
import com.sun.lwuit.spinner.DateTimeRenderer;
import com.sun.lwuit.spinner.SpinnerDateModel;
import com.sun.lwuit.spinner.SpinnerNumberModel;
import java.util.Calendar;
import java.util.Date;

public class Spinner
extends List {
    public static final int DATE_FORMAT_DD_MM_YYYY = 1;
    public static final int DATE_FORMAT_MM_DD_YYYY = 2;
    public static final int DATE_FORMAT_DD_MM_YY = 11;
    public static final int DATE_FORMAT_MM_DD_YY = 12;
    private static Image spinnerHandle;
    private long lastKeyInteraction;
    private TextField quickType = new TextField();
    private boolean monthFirst;
    private int currentInputAlign = 1;
    private static int inputSkipDelay;

    public static Spinner createTime(int min, int max, int currentValue, int step, boolean twentyFourHours, boolean showSeconds) {
        Spinner s = new Spinner(new SpinnerNumberModel(min, max, currentValue, step), DateTimeRenderer.createTimeRenderer(twentyFourHours, showSeconds));
        return s;
    }

    public static Spinner createDate(long min, long max, long currentValue, char separatorChar, int format) {
        Spinner s = new Spinner(new SpinnerDateModel(min, max, currentValue), DateTimeRenderer.createDateRenderer(separatorChar, format));
        s.monthFirst = format == 12 || format == 2;
        return s;
    }

    public static Spinner create(int min, int max, int currentValue, int step) {
        return new Spinner(new SpinnerNumberModel(min, max, currentValue, step), new DefaultListCellRenderer(false));
    }

    public static Spinner create(double min, double max, double currentValue, double step) {
        return new Spinner(new SpinnerNumberModel(min, max, currentValue, step), new DefaultListCellRenderer(false){

            public Component getListCellRendererComponent(List list, Object value, int index, boolean isSelected) {
                if (value != null && value instanceof Double) {
                    double d = (Double)value;
                    long l = (long)d;
                    long r = (long)(d * 100.0);
                    value = "" + l + "." + (r %= 100L);
                }
                return super.getListCellRendererComponent(list, value, index, isSelected);
            }
        });
    }

    private Spinner(ListModel model, ListCellRenderer rendererInstance) {
        super(model);
        this.setListCellRenderer(rendererInstance);
        this.setUIID("Spinner");
        this.setFixedSelection(12);
        this.setOrientation(0);
        this.setInputOnFocus(false);
        this.setIsScrollVisible(false);
        DefaultListCellRenderer render = (DefaultListCellRenderer)super.getRenderer();
        render.setRTL(false);
        render.setShowNumbers(false);
        render.setUIID("SpinnerRenderer");
        Component bgFocus = render.getListFocusComponent(this);
        bgFocus.getSelectedStyle().setBgTransparency(0);
        bgFocus.getUnselectedStyle().setBgTransparency(0);
        this.quickType.setReplaceMenu(false);
        this.quickType.setInputModeOrder(new String[]{"123"});
        this.quickType.setFocus(true);
        this.quickType.setRTL(false);
        this.quickType.setAlignment(1);
        this.setIgnoreFocusComponentWhenUnfocused(true);
        this.setRenderingPrototype(model.getItemAt(model.getSize() - 1));
        if (this.getRenderer() instanceof DateTimeRenderer) {
            this.quickType.setColumns(2);
        }
    }

    protected void initComponent() {
        this.getComponentForm().registerAnimated(this);
    }

    protected Dimension calcScrollSize() {
        return super.calcPreferredSize();
    }

    protected Dimension calcPreferredSize() {
        int boxWidth = 0;
        int verticalPadding = this.getStyle().getPadding(false, 0) + this.getStyle().getPadding(false, 2);
        int horizontalPadding = this.getStyle().getPadding(this.isRTL(), 3) + this.getStyle().getPadding(this.isRTL(), 1);
        Object prototype = this.getRenderingPrototype();
        ListCellRenderer renderer = this.getRenderer();
        Component cmp = prototype != null ? renderer.getListCellRendererComponent(this, prototype, 0, true) : (this.getModel().getSize() > 0 ? renderer.getListCellRendererComponent(this, this.getModel().getItemAt(0), 0, true) : renderer.getListCellRendererComponent(this, null, 0, true));
        int selectedHeight = cmp.getPreferredH();
        if (spinnerHandle != null) {
            if (spinnerHandle.getHeight() > selectedHeight) {
                selectedHeight = spinnerHandle.getHeight();
            }
            boxWidth += spinnerHandle.getWidth();
        }
        if (Display.getInstance().isTouchScreenDevice()) {
            return new Dimension(cmp.getPreferredW() + boxWidth + horizontalPadding, selectedHeight * 3 + verticalPadding);
        }
        return new Dimension(cmp.getPreferredW() + boxWidth + horizontalPadding, selectedHeight + verticalPadding);
    }

    public void keyPressed(int code) {
        int game = Display.getInstance().getGameAction(code);
        if (game > 0) {
            super.keyPressed(code);
        } else {
            this.quickType.keyPressed(code);
            this.lastKeyInteraction = System.currentTimeMillis();
        }
    }

    public void setValue(Object o) {
        ListModel m = this.getModel();
        if (m instanceof SpinnerDateModel) {
            ((SpinnerDateModel)m).setValue((Date)o);
        } else {
            ((SpinnerNumberModel)m).setValue(o);
        }
    }

    public Object getValue() {
        ListModel m = this.getModel();
        if (m instanceof SpinnerDateModel) {
            return ((SpinnerDateModel)m).getValue();
        }
        return ((SpinnerNumberModel)m).getValue();
    }

    public void keyReleased(int code) {
        int game = Display.getInstance().getGameAction(code);
        if (game > 0) {
            super.keyReleased(code);
        } else {
            try {
                this.quickType.keyReleased(code);
                this.lastKeyInteraction = System.currentTimeMillis();
                String t = this.quickType.getText();
                if (this.getRenderer() instanceof DateTimeRenderer) {
                    if (this.getModel() instanceof SpinnerNumberModel) {
                        int time = (Integer)this.getValue();
                        int seconds = time % 60;
                        int minutes = time / 60;
                        int hours = minutes / 60;
                        minutes %= 60;
                        switch (this.currentInputAlign) {
                            case 1: {
                                hours = Integer.parseInt(t);
                                if (!(((DateTimeRenderer)this.getRenderer()).isTwentyFourHours() ? hours > 24 : hours > 12)) break;
                                return;
                            }
                            case 4: {
                                minutes = Integer.parseInt(t);
                                if (minutes <= 59) break;
                                return;
                            }
                            case 3: {
                                seconds = Integer.parseInt(t);
                                if (seconds <= 59) break;
                                return;
                            }
                        }
                        int actual = seconds + minutes * 60 + hours * 60 * 60;
                        this.setValue(new Integer(actual));
                        if (this.quickType.getText().length() > 1) {
                            this.quickType.setText("");
                            switch (this.currentInputAlign) {
                                case 1: {
                                    this.currentInputAlign = 4;
                                    break;
                                }
                                case 4: {
                                    if (((DateTimeRenderer)this.getRenderer()).isShowSeconds()) {
                                        this.currentInputAlign = 3;
                                        break;
                                    }
                                    this.currentInputAlign = 1;
                                    this.lastKeyInteraction = -1L;
                                    break;
                                }
                                case 3: {
                                    this.currentInputAlign = 1;
                                    this.lastKeyInteraction = -1L;
                                }
                            }
                        }
                    } else {
                        Calendar c = Calendar.getInstance();
                        c.setTime((Date)this.getValue());
                        switch (this.currentInputAlign) {
                            case 1: {
                                if (this.monthFirst) {
                                    c.set(2, Integer.parseInt(t) - 1);
                                    break;
                                }
                                c.set(5, Integer.parseInt(t));
                                break;
                            }
                            case 4: {
                                if (this.monthFirst) {
                                    c.set(5, Integer.parseInt(t));
                                    break;
                                }
                                c.set(2, Integer.parseInt(t) - 1);
                                break;
                            }
                            case 3: {
                                int y = c.get(1);
                                c.set(1, y - y % 100 + Integer.parseInt(t));
                            }
                        }
                        this.setValue(c.getTime());
                        if (this.quickType.getText().length() > 1) {
                            this.quickType.setText("");
                            switch (this.currentInputAlign) {
                                case 1: {
                                    this.currentInputAlign = 4;
                                    break;
                                }
                                case 4: {
                                    this.currentInputAlign = 3;
                                    break;
                                }
                                case 3: {
                                    this.currentInputAlign = 1;
                                    this.lastKeyInteraction = -1L;
                                }
                            }
                        }
                    }
                    return;
                }
                SpinnerNumberModel n = (SpinnerNumberModel)this.getModel();
                if (n.realValues) {
                    double val = Double.parseDouble(t);
                    if (val > ((SpinnerNumberModel)this.getModel()).getMax() || val < ((SpinnerNumberModel)this.getModel()).getMin()) {
                        return;
                    }
                    this.setValue(new Double(val));
                } else {
                    int val = Integer.parseInt(t);
                    if ((double)val > ((SpinnerNumberModel)this.getModel()).getMax() || (double)val < ((SpinnerNumberModel)this.getModel()).getMin()) {
                        return;
                    }
                    this.setValue(new Integer(val));
                }
                int modelSize = this.getModel().getSize();
                for (int iter = 0; iter < modelSize; ++iter) {
                    String v = this.getModel().getItemAt(iter).toString();
                    if (!v.startsWith(t)) continue;
                    this.setSelectedIndex(iter);
                    return;
                }
            }
            catch (IllegalArgumentException ignore) {
                ignore.printStackTrace();
            }
        }
    }

    public boolean isRTL() {
        return false;
    }

    public void setRTL(boolean rtl) {
    }

    public void paint(Graphics g) {
        Style s;
        super.paint(g);
        if (spinnerHandle != null) {
            s = this.getStyle();
            g.drawImage(spinnerHandle, this.getX() + this.getWidth() - spinnerHandle.getWidth() - s.getPadding(this.isRTL(), 1) - s.getPadding(this.isRTL(), 3), this.getY() + s.getPadding(false, 0));
        }
        if (System.currentTimeMillis() - (long)inputSkipDelay < this.lastKeyInteraction || this.quickType.isPendingCommit()) {
            this.quickType.setWidth(Math.min(this.getWidth(), this.quickType.getPreferredW()));
            this.quickType.setHeight(Math.min(this.getHeight(), this.quickType.getPreferredH()));
            s = this.quickType.getStyle();
            this.quickType.setY(this.getScrollY() + this.getY());
            if (this.getRenderer() instanceof DateTimeRenderer) {
                switch (this.currentInputAlign) {
                    case 1: {
                        this.quickType.setX(this.getX());
                        break;
                    }
                    case 3: {
                        this.quickType.setX(this.getX() + this.quickType.getStyle().getFont().charWidth(TextArea.getWidestChar()) * 4 + s.getMargin(false, 3));
                        break;
                    }
                    default: {
                        this.quickType.setX(this.getX() + this.quickType.getStyle().getFont().charWidth(TextArea.getWidestChar()) * 2 + s.getMargin(false, 3));
                        break;
                    }
                }
            } else {
                this.quickType.setX(this.getX());
            }
            this.quickType.paintComponent(g, true);
        }
    }

    public boolean animate() {
        boolean val = super.animate();
        if (this.lastKeyInteraction != -1L) {
            this.quickType.animate();
            if (System.currentTimeMillis() - (long)inputSkipDelay > this.lastKeyInteraction && !this.quickType.isPendingCommit()) {
                this.lastKeyInteraction = -1L;
                this.quickType.clear();
                this.currentInputAlign = 1;
            }
            return true;
        }
        return val;
    }

    public static Image getSpinnerHandle() {
        return spinnerHandle;
    }

    public static void setSpinnerHandle(Image aSpinnerHandle) {
        spinnerHandle = aSpinnerHandle;
    }

    public static int getInputSkipDelay() {
        return inputSkipDelay;
    }

    public static void setInputSkipDelay(int aInputSkipDelay) {
        inputSkipDelay = aInputSkipDelay;
    }

    static {
        inputSkipDelay = 2000;
    }
}

