/*
 * Decompiled with CFR 0.152.
 */
package com.sun.lwuit.table;

import com.sun.lwuit.Component;
import com.sun.lwuit.Container;
import com.sun.lwuit.geom.Dimension;
import com.sun.lwuit.layouts.Layout;
import com.sun.lwuit.plaf.Style;

public class TableLayout
extends Layout {
    private int currentRow;
    private int currentColumn;
    private static int minimumSizePerColumn = 10;
    private Constraint[][] tablePositions;
    private int[] columnSizes;
    private int[] columnPositions;
    private int[] rowPositions;
    private boolean[] modifableColumnSize;
    private static final Constraint H_SPAN_CONSTRAINT = new Constraint();
    private static final Constraint V_SPAN_CONSTRAINT = new Constraint();
    private static final Constraint VH_SPAN_CONSTRAINT = new Constraint();
    private static int defaultColumnWidth = -1;
    private static int defaultRowHeight = -1;
    private boolean horizontalSpanningExists;
    private boolean verticalSpanningExists;

    public TableLayout(int rows, int columns) {
        this.tablePositions = new Constraint[rows][columns];
    }

    public Component getComponentAt(int row, int column) {
        return this.tablePositions[row][column].parent;
    }

    public void layoutContainer(Container parent) {
        int iter;
        this.verticalSpanningExists = false;
        this.horizontalSpanningExists = false;
        Style s = parent.getStyle();
        int top = s.getPadding(false, 0);
        int left = s.getPadding(parent.isRTL(), 1);
        int bottom = s.getPadding(false, 2);
        int right = s.getPadding(parent.isRTL(), 3);
        boolean rtl = parent.isRTL();
        this.columnSizes = new int[this.tablePositions[0].length];
        if (this.modifableColumnSize == null) {
            this.modifableColumnSize = new boolean[this.tablePositions[0].length];
        }
        this.columnPositions = new int[this.tablePositions[0].length];
        int[] rowSizes = new int[this.tablePositions.length];
        this.rowPositions = new int[this.tablePositions.length];
        int pWidth = parent.getLayoutWidth() - parent.getSideGap() - left - right;
        int pHeight = parent.getLayoutHeight() - parent.getBottomGap() - top - bottom;
        int currentX = left;
        for (iter = 0; iter < this.columnSizes.length; ++iter) {
            this.columnSizes[iter] = this.getColumnWidthPixels(iter, pWidth, pWidth);
        }
        if (!parent.isScrollableX()) {
            int totalWidth = 0;
            int totalModifyablePixels = 0;
            for (int iter2 = 0; iter2 < this.modifableColumnSize.length; ++iter2) {
                if (this.modifableColumnSize[iter2]) {
                    totalModifyablePixels += this.columnSizes[iter2];
                }
                totalWidth += this.columnSizes[iter2];
            }
            if (pWidth < totalWidth) {
                int totalPixelsToRemove = totalWidth - pWidth;
                int totalPixelsNecessary = totalModifyablePixels - totalPixelsToRemove;
                for (int iter3 = 0; iter3 < this.modifableColumnSize.length; ++iter3) {
                    if (!this.modifableColumnSize[iter3]) continue;
                    this.columnSizes[iter3] = (int)((float)this.columnSizes[iter3] / (float)totalModifyablePixels * (float)totalPixelsNecessary);
                }
            }
        }
        for (iter = 0; iter < this.columnSizes.length; ++iter) {
            if (rtl) {
                this.columnPositions[iter] = pWidth - (currentX += this.columnSizes[iter]);
                continue;
            }
            this.columnPositions[iter] = currentX;
            currentX += this.columnSizes[iter];
        }
        int currentY = top;
        for (int iter4 = 0; iter4 < rowSizes.length; ++iter4) {
            rowSizes[iter4] = parent.isScrollableY() ? this.getRowHeightPixels(iter4, pHeight, -1) : this.getRowHeightPixels(iter4, pHeight, pHeight - currentY);
            this.rowPositions[iter4] = currentY;
            currentY += rowSizes[iter4];
        }
        for (int r = 0; r < rowSizes.length; ++r) {
            for (int c = 0; c < this.columnSizes.length; ++c) {
                int conH;
                int conW;
                Constraint con = this.tablePositions[r][c];
                if (con == null || con == H_SPAN_CONSTRAINT || con == V_SPAN_CONSTRAINT || con == VH_SPAN_CONSTRAINT) continue;
                Style componentStyle = con.parent.getStyle();
                int leftMargin = componentStyle.getMargin(parent.isRTL(), 1);
                int topMargin = componentStyle.getMargin(false, 0);
                int conX = left + leftMargin + this.columnPositions[c];
                int conY = top + topMargin + this.rowPositions[r];
                if (con.spanHorizontal > 1) {
                    this.horizontalSpanningExists = true;
                    int w = this.columnSizes[c];
                    for (int sh = 1; sh < con.spanHorizontal; ++sh) {
                        w += this.columnSizes[c + sh];
                    }
                    if (rtl) {
                        conX = left + leftMargin + this.columnPositions[c + con.spanHorizontal - 1];
                    }
                    conW = w - leftMargin - componentStyle.getMargin(parent.isRTL(), 3);
                } else {
                    conW = this.columnSizes[c] - leftMargin - componentStyle.getMargin(parent.isRTL(), 3);
                }
                if (con.spanVertical > 1) {
                    this.verticalSpanningExists = true;
                    int h = rowSizes[r];
                    for (int sv = 1; sv < con.spanVertical; ++sv) {
                        h += rowSizes[r + sv];
                    }
                    conH = h - topMargin - componentStyle.getMargin(false, 2);
                } else {
                    conH = rowSizes[r] - topMargin - componentStyle.getMargin(false, 2);
                }
                this.placeComponent(rtl, con, conX, conY, conW, conH);
            }
        }
    }

    public int getRowPosition(int row) {
        if (this.rowPositions != null && this.rowPositions.length > row) {
            return this.rowPositions[row];
        }
        return -1;
    }

    public int getColumnPosition(int col) {
        if (this.columnPositions != null && this.columnPositions.length > col) {
            return this.columnPositions[col];
        }
        return -1;
    }

    private void placeComponent(boolean rtl, Constraint con, int x, int y, int width, int height) {
        int d;
        con.parent.setX(x);
        con.parent.setY(y);
        con.parent.setWidth(width);
        con.parent.setHeight(height);
        Dimension pref = con.parent.getPreferredSize();
        int pWidth = pref.getWidth();
        int pHeight = pref.getHeight();
        if (pWidth < width) {
            d = width - pWidth;
            int a = con.align;
            if (rtl) {
                switch (a) {
                    case 1: {
                        a = 3;
                        break;
                    }
                    case 3: {
                        a = 1;
                    }
                }
            }
            switch (a) {
                case 1: {
                    con.parent.setX(x);
                    con.parent.setWidth(width - d);
                    break;
                }
                case 3: {
                    con.parent.setX(x + d);
                    con.parent.setWidth(width - d);
                    break;
                }
                case 4: {
                    con.parent.setX(x + d / 2);
                    con.parent.setWidth(width - d);
                }
            }
        }
        if (pHeight < height) {
            d = height - pHeight;
            switch (con.valign) {
                case 0: {
                    con.parent.setY(y);
                    con.parent.setHeight(height - d);
                    break;
                }
                case 2: {
                    con.parent.setY(y + d);
                    con.parent.setHeight(height - d);
                    break;
                }
                case 4: {
                    con.parent.setY(y + d / 2);
                    con.parent.setHeight(height - d);
                }
            }
        }
    }

    private int getColumnWidthPixels(int column, int percentageOf, int available) {
        int current = 0;
        if (this.modifableColumnSize == null) {
            this.modifableColumnSize = new boolean[this.tablePositions[0].length];
        }
        for (int iter = 0; iter < this.tablePositions.length; ++iter) {
            Constraint c = this.tablePositions[iter][column];
            if (c == null || c == H_SPAN_CONSTRAINT || c == V_SPAN_CONSTRAINT || c == VH_SPAN_CONSTRAINT || c.spanHorizontal > 1) continue;
            if (c.width > 0 && available > -1) {
                current = Math.max(current, c.width * percentageOf / 100);
                this.modifableColumnSize[column] = false;
            } else {
                Style s = c.parent.getStyle();
                current = Math.max(current, c.parent.getPreferredW() + s.getMargin(false, 1) + s.getMargin(false, 3));
                this.modifableColumnSize[column] = true;
            }
            if (available <= -1) continue;
            current = Math.min(available, current);
        }
        return current;
    }

    private int getRowHeightPixels(int row, int percentageOf, int available) {
        int current = 0;
        for (int iter = 0; iter < this.tablePositions[row].length; ++iter) {
            Constraint c = this.tablePositions[row][iter];
            if (c == null || c == H_SPAN_CONSTRAINT || c == V_SPAN_CONSTRAINT || c == VH_SPAN_CONSTRAINT || c.spanVertical > 1) continue;
            if (c.height > 0) {
                current = Math.max(current, c.height * percentageOf / 100);
            } else {
                Style s = c.parent.getStyle();
                current = Math.max(current, c.parent.getPreferredH() + s.getMargin(false, 2) + s.getMargin(false, 0));
            }
            if (available <= -1) continue;
            current = Math.min(available, current);
        }
        return current;
    }

    public Dimension getPreferredSize(Container parent) {
        int iter;
        Style s = parent.getStyle();
        int w = s.getPadding(false, 1) + s.getPadding(false, 3);
        int h = s.getPadding(false, 0) + s.getPadding(false, 2);
        for (iter = 0; iter < this.tablePositions[0].length; ++iter) {
            w += this.getColumnWidthPixels(iter, Integer.MAX_VALUE, -1);
        }
        for (iter = 0; iter < this.tablePositions.length; ++iter) {
            h += this.getRowHeightPixels(iter, Integer.MAX_VALUE, -1);
        }
        return new Dimension(w, h);
    }

    public int getNextRow() {
        return this.currentRow;
    }

    public int getNextColumn() {
        return this.currentColumn;
    }

    public void addLayoutComponent(Object value, Component comp, Container c) {
        Constraint con = (Constraint)value;
        if (con == null) {
            con = this.createConstraint();
        } else if (con.parent != null) {
            throw new IllegalArgumentException("Constraint already associated with component!");
        }
        if (con.row < 0) {
            con.row = this.currentRow;
        }
        if (con.column < 0) {
            con.column = this.currentColumn;
        }
        con.parent = comp;
        if (this.tablePositions[con.row][con.column] != null) {
            throw new IllegalArgumentException("Row: " + con.row + " and column: " + con.column + " already occupied");
        }
        this.tablePositions[((Constraint)con).row][((Constraint)con).column] = con;
        if (con.spanHorizontal > 1 || con.spanVertical > 1) {
            for (int sh = 0; sh < con.spanHorizontal; ++sh) {
                for (int sv = 0; sv < con.spanVertical; ++sv) {
                    if (sh <= 0 && sv <= 0 || this.tablePositions[con.row + sv][con.column + sh] != null) continue;
                    if (con.spanHorizontal > 1) {
                        if (con.spanVertical > 1) {
                            this.tablePositions[((Constraint)con).row + sv][((Constraint)con).column + sh] = VH_SPAN_CONSTRAINT;
                            continue;
                        }
                        this.tablePositions[((Constraint)con).row + sv][((Constraint)con).column + sh] = V_SPAN_CONSTRAINT;
                        continue;
                    }
                    this.tablePositions[((Constraint)con).row + sv][((Constraint)con).column + sh] = H_SPAN_CONSTRAINT;
                }
            }
        }
        this.updateRowColumn();
    }

    private void updateRowColumn() {
        if (this.currentRow >= this.tablePositions.length) {
            return;
        }
        while (this.tablePositions[this.currentRow][this.currentColumn] != null) {
            ++this.currentColumn;
            if (this.currentColumn < this.tablePositions[0].length) continue;
            this.currentColumn = 0;
            ++this.currentRow;
            if (this.currentRow < this.tablePositions.length) continue;
            return;
        }
    }

    public int getCellHorizontalSpan(int row, int column) {
        return this.tablePositions[row][column].spanHorizontal;
    }

    public int getCellVerticalSpan(int row, int column) {
        return this.tablePositions[row][column].spanVertical;
    }

    public boolean isCellSpannedThroughVertically(int row, int column) {
        return this.tablePositions[row][column] == V_SPAN_CONSTRAINT || this.tablePositions[row][column] == VH_SPAN_CONSTRAINT;
    }

    public boolean isCellSpannedThroughHorizontally(int row, int column) {
        return this.tablePositions[row][column] == H_SPAN_CONSTRAINT || this.tablePositions[row][column] == VH_SPAN_CONSTRAINT;
    }

    public boolean hasVerticalSpanning() {
        return this.verticalSpanningExists;
    }

    public boolean hasHorizontalSpanning() {
        return this.horizontalSpanningExists;
    }

    public void removeLayoutComponent(Component comp) {
        for (int r = 0; r < this.tablePositions.length; ++r) {
            for (int c = 0; c < this.tablePositions[r].length; ++c) {
                if (this.tablePositions[r][c] == null || this.tablePositions[r][c].parent != comp) continue;
                this.tablePositions[r][c] = null;
                return;
            }
        }
    }

    public Object getComponentConstraint(Component comp) {
        for (int r = 0; r < this.tablePositions.length; ++r) {
            for (int c = 0; c < this.tablePositions[r].length; ++c) {
                if (this.tablePositions[r][c] == null || this.tablePositions[r][c].parent != comp) continue;
                return this.tablePositions[r][c];
            }
        }
        return null;
    }

    public Constraint createConstraint() {
        return new Constraint();
    }

    public Constraint createConstraint(int row, int column) {
        Constraint c = this.createConstraint();
        c.row = row;
        c.column = column;
        return c;
    }

    public static void setMinimumSizePerColumn(int minimumSize) {
        minimumSizePerColumn = minimumSize;
    }

    public static int getMinimumSizePerColumn() {
        return minimumSizePerColumn;
    }

    public static void setDefaultColumnWidth(int w) {
        defaultColumnWidth = w;
    }

    public static int getDefaultColumnWidth() {
        return defaultColumnWidth;
    }

    public static void setDefaultRowHeight(int h) {
        defaultRowHeight = h;
    }

    public static int getDefaultRowHeight() {
        return defaultRowHeight;
    }

    static /* synthetic */ int access$900() {
        return defaultColumnWidth;
    }

    static /* synthetic */ int access$1000() {
        return defaultRowHeight;
    }

    public static class Constraint {
        private Component parent;
        private int row = -1;
        private int column = -1;
        private int width = TableLayout.access$900();
        private int height = TableLayout.access$1000();
        private int spanHorizontal = 1;
        private int spanVertical = 1;
        private int align = -1;
        private int valign = -1;

        public void setVerticalSpan(int span) {
            if (span < 1) {
                throw new IllegalArgumentException("Illegal span");
            }
            this.spanVertical = span;
        }

        public void setHorizontalSpan(int span) {
            if (span < 1) {
                throw new IllegalArgumentException("Illegal span");
            }
            this.spanHorizontal = span;
        }

        public void setWidthPercentage(int width) {
            this.width = width;
        }

        public void setHeightPercentage(int height) {
            this.height = height;
        }

        public void setHorizontalAlign(int align) {
            this.align = align;
        }

        public void setVerticalAlign(int valign) {
            this.valign = valign;
        }
    }
}

